const categories = [
  { id: 'all', name: 'همه موارد' },
  { id: 'hot', name: 'نوشیدنی گرم' },
  { id: 'cold', name: 'نوشیدنی سرد' },
  { id: 'macha', name: 'ماچا' },
  { id: 'shake', name: 'شیک' },
  { id: 'sandwich', name: 'ساندویچ‌ها' },
  { id: 'pasta', name: 'پاستا' },
  { id: 'sides', name: 'سیب' },
  { id: 'bakery', name: 'بیکری' },
  { id: 'dessert', name: 'دسرها' },
  { id: 'tea', name: 'دمنوش‌ها' },
];

const menuItems = [
  // --- Hot Drinks ---
  {
    title: "اسپرسو ۷۰*۳۰",
    desc: "",
    price: "-- تومان",
    img: "",
    type: "hot",
  },
  {
    title: "اسپرسو ۱۰۰ عربیکا",
    desc: "",
    price: "-- تومان",
    img: "",
    type: "hot",
  },
  {
    title: "اسپرسو ۵۰*۵۰",
    desc: "",
    price: "-- تومان",
    img: "",
    type: "hot",
  },
  {
    title: "آمریکانو",
    desc: "یک شات اسپرسو , آب جوش",
    price: "-- تومان",
    img: "",
    type: "hot",
  },
  {
    title: "لاته",
    desc: "یک شات اسپرسو , شیر بخار داده شده , فوم شیر",
    price: "-- تومان",
    img: "",
    type: "hot",
  },
  {
    title: "کاپوچینو کلاسیک",
    desc: "یک شات اسپرسو , شیر بخار داده شده بیشتر",
    price: "-- تومان",
    img: "",
    type: "hot",
  },
  {
    title: "کاپوچینو پودری",
    desc: "پودر کاپوچینو , فوم شیر",
    price: "-- تومان",
    img: "",
    type: "hot",
  },
  {
    title: "کورتادو",
    desc: "اسپرسو , کمی شیر بخار داده شده (نسبت شیر کم، طعم قهوه قوی اما نرم‌تر)",
    price: "-- تومان",
    img: "",
    type: "hot",
  },
  {
    title: "کارامل ماکیاتو",
    desc: "اسپرسو , شیر بخار داده , سس کارامل , سیروپ کارامل",
    price: "-- تومان",
    img: "",
    type: "hot",
  },
  {
    title: "موکا",
    desc: "اسپرسو , شیر بخار داده , شکلات (طعم قهوه‌ شکلاتی و شیرین)",
    price: "-- تومان",
    img: "",
    type: "hot",
  },
  {
    title: "لاته کارامل",
    desc: "اسپرسو , شیر بخار داده شده , سیروپ کارامل (نرم، شیرین و کرمی با طعم کارامل)",
    price: "-- تومان",
    img: "",
    type: "hot",
  },
  {
    title: "لاته فندق",
    desc: "اسپرسو , شیر بخار داده , سیروپ فندق (کرمی، گرم و با طعم فندقی ملایم)",
    price: "-- تومان",
    img: "",
    type: "hot",
  },

  // --- Cold Drinks ---
  {
    title: "آیس آمریکانو",
    desc: "اسپرسو روی یخ , آب سرد (طعم خنک، تلخ و سبک‌تر از اسپرسو)",
    price: "-- تومان",
    img: "",
    type: "cold",
  },
  {
    title: "آیس لاته",
    desc: "اسپرسو , شیر سرد روی یخ (خنک، سبک و کرمی)",
    price: "-- تومان",
    img: "",
    type: "cold",
  },
  {
    title: "آیس موکا",
    desc: "اسپرسو , شیر سرد , سیروپ شکلات روی یخ (خنک، شیرین و قهوه‌ـشکلاتی)",
    price: "-- تومان",
    img: "",
    type: "cold",
  },
  {
    title: "آفوگاتو",
    desc: "یک اسکوپ بستنی وانیل که روی آن شات داغ اسپرسو ریخته می‌شود (ترکیب داغ و سرد؛ شیرین و قهوه‌ای)",
    price: "-- تومان",
    img: "",
    type: "cold",
  },
  {
    title: "آفوپسته",
    desc: "کرم پسته‌ای , شات داغ اسپرسو (ترکیب گرم و سرد با طعم پسته‌ای و قهوه‌ای)",
    price: "-- تومان",
    img: "",
    type: "cold",
  },

  // --- Macha ---
  {
    title: "ماچا لاته",
    desc: "پودر ماچا , شیر گرم یا سرد (طعم گیاهی، ملایم و آرام‌بخش)",
    price: "-- تومان",
    img: "",
    type: "macha",
  },
  {
    title: "آیس ماچا نارگیل",
    desc: "پودر ماچا , شیر نارگیل سرد روی یخ , سیروپ نارگیل (خنک، سبک و با طعم ماچای گرمسیری)",
    price: "-- تومان",
    img: "",
    type: "macha",
  },
  {
    title: "آیس ماچا انبه",
    desc: "پودر ماچا , پوره یا شربت انبه , شیر سرد روی یخ (خنک، میوه‌ای و ترکیب جذاب ماچا با طعم انبه)",
    price: "-- تومان",
    img: "",
    type: "macha",
  },

  // --- Shake ---
  {
    title: "شیک اسپرسو",
    desc: "اسپرسو , بستنی , شیر (غلیظ، خنک و کافه‌ای شیرین)",
    price: "-- تومان",
    img: "",
    type: "shake",
  },
  {
    title: "شیک نوتلا",
    desc: "بستنی , شیر , نوتلا (غلیظ، شکلاتی و خیلی خوشمزه)",
    price: "-- تومان",
    img: "",
    type: "shake",
  },
  {
    title: "شیک لوتوس",
    desc: "بستنی , شیر , کره یا بیسکوییت لوتوس (غلیظ، کاراملی و خوش‌طعم)",
    price: "-- تومان",
    img: "",
    type: "shake",
  },
  {
    title: "شیک موز شکلات",
    desc: "بستنی , شیر , موز , شکلات (غلیظ، انرژی‌زا و طعم عالی موز و شکلات)",
    price: "-- تومان",
    img: "",
    type: "shake",
  },
  {
    title: "شیک انبه",
    desc: "بستنی , شیر , پوره انبه (خنک، میوه‌ای و شیرین با عطر انبه)",
    price: "-- تومان",
    img: "",
    type: "shake",
  },
  {
    title: "شیک توت فرنگی",
    desc: "بستنی , شیر , توت فرنگی (خنک و میوه ایی با عطر تازه توت فرنگی)",
    price: "-- تومان",
    img: "",
    type: "shake",
  },
  {
    title: "شیک شکلات",
    desc: "بستنی شکلاتی , شیر (کرمی و خوشمزه با طعم شکلات اصیل)",
    price: "-- تومان",
    img: "",
    type: "shake",
  },
  {
    title: "شیک اورئو",
    desc: "بستنی , شیر , اورئو , شکلات (کرمی و خوشمزه با تکه های اورئو)",
    price: "-- تومان",
    img: "",
    type: "shake",
  },
  {
    title: "شیک استرابری نوتلا",
    desc: "بستنی , شیر , توت فرنگی , نوتلا (ترکیبی خوشمزه از توت فرنگی تازه و نوتلا کرمی)",
    price: "-- تومان",
    img: "",
    type: "shake",
  },
  {
    title: "شیک مگنوم چاکلت",
    desc: "نوتلا , بستنی , کیک دبل چاکلت",
    price: "-- تومان",
    img: "",
    type: "shake",
  },
  {
    title: "شیک وانیل",
    desc: "بستنی وانیلی , شیر (لطیف و خوش‌طعم با عطر وانیل کلاسیک)",
    price: "-- تومان",
    img: "",
    type: "shake",
  },

  // --- Sandwiches ---
  { title: "مرغ پیازچه", desc: "", price: "-- تومان", img: "", type: "sandwich" },
  { title: "مرغ چدار", desc: "", price: "-- تومان", img: "", type: "sandwich" },
  { title: "رول هات داگ", desc: "", price: "-- تومان", img: "", type: "sandwich" },
  { title: "چاپاتا ژامبون", desc: "", price: "-- تومان", img: "", type: "sandwich" },
  { title: "چاپاتا مرغ", desc: "", price: "-- تومان", img: "", type: "sandwich" },
  { title: "اشترودل پیتزایی", desc: "", price: "-- تومان", img: "", type: "sandwich" },
  { title: "اشترودل مرغ", desc: "", price: "-- تومان", img: "", type: "sandwich" },
  { title: "کروسان ژامبون", desc: "", price: "-- تومان", img: "", type: "sandwich" },
  { title: "مینی پیتزا مخصوص", desc: "", price: "-- تومان", img: "", type: "sandwich" },
  { title: "پنینی مرغ", desc: "", price: "-- تومان", img: "", type: "sandwich" },
  { title: "پنینی بیکن", desc: "", price: "-- تومان", img: "", type: "sandwich" },
  { title: "پنینی هات داگ", desc: "", price: "-- تومان", img: "", type: "sandwich" },

  // --- Pasta ---
  { title: "پاستا پنه آلفردو", desc: "", price: "-- تومان", img: "", type: "pasta" },

  // --- Sides (سیب) ---
  { title: "سیب ساده", desc: "", price: "-- تومان", img: "", type: "sides" },
  { title: "سیب چدار", desc: "", price: "-- تومان", img: "", type: "sides" },
  { title: "سیب آلفردو", desc: "", price: "-- تومان", img: "", type: "sides" },
  { title: "سیب بیکن", desc: "", price: "-- تومان", img: "", type: "sides" },

  // --- Bakery ---
  { title: "کروسان کره ایی", desc: "", price: "-- تومان", img: "", type: "bakery" },
  { title: "بیبی کروسان کره ایی", desc: "", price: "-- تومان", img: "", type: "bakery" },
  { title: "کروسان نوتلایی", desc: "", price: "-- تومان", img: "", type: "bakery" },
  { title: "بیبی کروسان نوتلایی", desc: "", price: "-- تومان", img: "", type: "bakery" },
  { title: "کروسان لوتوس", desc: "", price: "-- تومان", img: "", type: "bakery" },
  { title: "بیبی کروسان لوتوس", desc: "", price: "-- تومان", img: "", type: "bakery" },
  { title: "کروسان موز نوتلا", desc: "", price: "-- تومان", img: "", type: "bakery" },
  { title: "کیوب کروسان نوتلایی", desc: "", price: "-- تومان", img: "", type: "bakery" },
  { title: "یوشان نوتلایی", desc: "", price: "-- تومان", img: "", type: "bakery" },
  { title: "دنیش نوتلایی", desc: "", price: "-- تومان", img: "", type: "bakery" },
  { title: "پن شکلات", desc: "", price: "-- تومان", img: "", type: "bakery" },
  { title: "چاکلت توئیست", desc: "", price: "-- تومان", img: "", type: "bakery" },
  { title: "سینامون رول", desc: "", price: "-- تومان", img: "", type: "bakery" },
  { title: "پیراشکی", desc: "", price: "-- تومان", img: "", type: "bakery" },
  { title: "دونات روکش شکلات", desc: "", price: "-- تومان", img: "", type: "bakery" },

  // --- Desserts / Cakes ---
  { title: "چیز کیک", desc: "", price: "-- تومان", img: "", type: "dessert" },
  { title: "چیزکیک شکلاتی", desc: "", price: "-- تومان", img: "", type: "dessert" },
  { title: "چیز کیک لوتوس", desc: "", price: "-- تومان", img: "", type: "dessert" },
  { title: "چیز کیک نیویورکی", desc: "", price: "-- تومان", img: "", type: "dessert" },
  { title: "چیزکیک نوتلا", desc: "", price: "-- تومان", img: "", type: "dessert" },
  { title: "کیک روز", desc: "", price: "-- تومان", img: "", type: "dessert" },
  { title: "کیک شکلاتی", desc: "", price: "-- تومان", img: "", type: "dessert" },

  // --- Teas (دمنوش‌ها) ---
  { title: "دمنوش آویشن", desc: "", price: "-- تومان", img: "", type: "tea" },
  { title: "دمنوش آرامش", desc: "", price: "-- تومان", img: "", type: "tea" },
  { title: "دمنوش لیمو عسل", desc: "", price: "-- تومان", img: "", type: "tea" },
  { title: "دمنوش لونا", desc: "", price: "-- تومان", img: "", type: "tea" },
  { title: "دمنوش سرخ", desc: "", price: "-- تومان", img: "", type: "tea" },
  { title: "دمنوش بابونه", desc: "", price: "-- تومان", img: "", type: "tea" },
];

const catsContainer = document.getElementById('categories');
const itemsContainer = document.getElementById('menuItems');
let activeCat = categories[0].id;

function renderCategories() {
  catsContainer.innerHTML = '';
  categories.forEach(cat => {
    const btn = document.createElement('button');
    btn.className = 'filter-btn' + (cat.id === activeCat ? ' active' : '');
    btn.innerText = cat.name;
    btn.onclick = () => {
      activeCat = cat.id;
      renderCategories();
      renderItems();
    };
    catsContainer.appendChild(btn);
  });
}

function renderItems() {
  itemsContainer.innerHTML = '';
  window.scrollTo({ top: 0 });
  let items;
  if (activeCat === 'all') {
    items = menuItems;
  } else {
    items = menuItems.filter(item => item.type === activeCat);
  }
  if (items.length === 0) {
    itemsContainer.innerHTML = '<div style="text-align:center;color:#b8a57e;margin-top:18px">موردی در این دسته وجود ندارد</div>';
    return;
  }
  items.forEach(item => {
    const el = document.createElement('div');
    el.className = 'menu-item';
    el.innerHTML = `
      <img src="${item.img}" class="menu-img" alt="${item.title}"/>
      <div class="menu-info">
        <div class="item-title">${item.title}</div>
        <div class="item-desc">${item.desc}</div>
        <div class="item-price">${item.price}</div>
      </div>
    `;
    itemsContainer.appendChild(el);
  });
}

renderCategories();
renderItems();